/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns;

import com.tacz.guns.GunModComponents;
import com.tacz.guns.api.resource.ResourceManager;
import com.tacz.guns.config.ClientConfig;
import com.tacz.guns.config.CommonConfig;
import com.tacz.guns.config.ServerConfig;
import com.tacz.guns.init.CommandRegistry;
import com.tacz.guns.init.CommonRegistry;
import com.tacz.guns.init.CompatRegistry;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.init.ModContainer;
import com.tacz.guns.init.ModCreativeTabs;
import com.tacz.guns.init.ModDamageTypes;
import com.tacz.guns.init.ModEntities;
import com.tacz.guns.init.ModEvents;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.init.ModParticles;
import com.tacz.guns.init.ModRecipe;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.resource.DedicatedServerReloadManager;
import com.tacz.guns.util.EnvironmentUtil;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import net.fabricmc.api.ModInitializer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GunMod
implements ModInitializer {
    public static final String OLD_MOD_ID = "tacz-fabric";
    public static final String MOD_ID = "tacz";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tacz".toUpperCase());
    public static final String DEFAULT_GUN_PACK_NAME = "tacz_default_gun";

    public void onInitialize() {
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.init());
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.init());
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.init());
        ModEvents.init();
        ModBlocks.init();
        ModCreativeTabs.init();
        ModItems.init();
        ModEntities.init();
        ModRecipe.init();
        ModContainer.init();
        ModSounds.init();
        ModParticles.init();
        ModDamageTypes.init();
        CommonRegistry.init();
        CommandRegistry.init();
        CompatRegistry.init();
        GunModComponents.init();
        GunMod.registerDefaultExtraGunPack();
        if (EnvironmentUtil.isServer()) {
            DedicatedServerReloadManager.loadGunPack();
        }
    }

    private static void registerDefaultExtraGunPack() {
        String jarDefaultPackPath = String.format("/assets/%s/custom/%s", MOD_ID, DEFAULT_GUN_PACK_NAME);
        ResourceManager.registerExtraGunPack(GunMod.class, jarDefaultPackPath);
    }
}

